/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.util.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Logo
extends Frame {
    private static final String TRACE_MASKT = "XFRMLOGT:";
    private static final String TRACE_MASKF = "XFRMLOGF:";
    private static final String TRACE_MASKD = "XFRMLOGD:";

    public Logo(String title, ImageIcon image, String[] textLines) {
        super(title);
        int panels = 0;
        JPanel imagePanel = null;
        JPanel textPanel = null;
        Trace.trace(TRACE_MASKT, "-> Logo.Logo()");
        JPanel logoPanel = new JPanel();
        logoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (image != null) {
            imagePanel = new JPanel(new GridLayout(1, 1));
            ++panels;
            JLabel imageLabel = new JLabel(image);
            imageLabel.setVerticalAlignment(1);
            imagePanel.add(imageLabel);
        }
        if (textLines != null && textLines.length > 0) {
            textPanel = new JPanel(new GridLayout(textLines.length, 1));
            ++panels;
            int i = 0;
            while (i < textLines.length) {
                textPanel.add(new JLabel(textLines[i], 0));
                ++i;
            }
        }
        if (panels > 0) {
            logoPanel.setLayout(new BorderLayout());
            if (imagePanel != null) {
                logoPanel.add((Component)imagePanel, "Center");
            }
            if (textPanel != null) {
                logoPanel.add((Component)textPanel, "South");
            }
        }
        this.add(logoPanel);
        this.setResizable(false);
        this.pack();
        this.centerWindowOnScreen(this);
        this.setVisible(true);
        this.show();
        Trace.trace(TRACE_MASKT, "<- Logo.Logo()");
    }

    private void centerWindowOnScreen(Window window) {
        Toolkit tools = Toolkit.getDefaultToolkit();
        Dimension screenSize = tools.getScreenSize();
        Rectangle rectangle = window.getBounds();
        double frameWidth = rectangle.getWidth();
        double frameHeight = rectangle.getHeight();
        if (frameWidth + 50.0 > (double)screenSize.width) {
            frameWidth = screenSize.width - 50;
        }
        if (frameHeight + 50.0 > (double)screenSize.height) {
            frameHeight = screenSize.height - 50;
        }
        window.setBounds((int)(((double)screenSize.width - frameWidth) / 2.0), (int)(((double)screenSize.height - frameHeight) / 2.0), (int)frameWidth, (int)frameHeight);
    }
}

